package ru.yandex.tours.model.hotels

import ru.yandex.tours.model.Languages
import ru.yandex.tours.model.Languages.Lang

/* @author berkut@yandex-team.ru */

object Name {
  def serialize(names: Map[Lang, Name]) = names.map(t => t._2.serialize).mkString("\t")

  def deserialize(names: String) = {
    val parts = names.split("\t")
    (0 until (parts.size / 2)).map(i => {
      val lang = Languages.withName(parts(i * 2))
      val name = parts(i * 2 + 1)
      lang -> Name(lang, name)
    }).toMap
  }
}

case class Name(lang: Lang, name: String) {
  def serialize = lang.toString + "\t" + name.replaceAll("\t", " ")
}
