package ru.yandex.tours.model.hotels

import ru.yandex.tours.model.search.SearchType._

import scala.util.Try

/* @author berkut@yandex-team.ru */

object Partners extends Enumeration with ChannelManagersEnum {
  type Partner = Value

  val unknown = Value(0, "unknown")
  val yandex = Value(1, "yandex")
  val booking = Value(2, "booking")
  val hrs = Value(3, "hrs")
  val ostrovok = Value(4, "ostrovok")
  val lt = Value(5, "lt")
  val backa = Value(6, "backa")
  val sunmar = Value(7, "sunmar")
  val oktogo = Value(8, "oktogo")
  val hotels101 = Value(9, "101hotels")
  val topHotels = Value(10, "tophotels")
  val sodis = Value(11, "sodis")
  val rozahutor = Value(12, "rozahutor")
  val travelline = Value(13, "travelline")
  val inna = Value(14, "inna")
  val vashotel = Value(15, "vashotel")
  val hotelbook = Value(16, "hotelbook")
  val kurortExpress = Value(17, "kurortexpress")
  val hotelsCombined = Value(18, "hotelscombined")
  // Some ids are used by mappings for hotelscombined
  val ostrovokv3 = Value(30, "ostrovokv3")
  val ostrovokFenced = Value(300, "ostrovokFenced")

  private val partner2searchType = Set(
    yandex -> ROOMS,
    yandex -> TOURS,
    booking -> ROOMS,
    hrs -> ROOMS,
    ostrovok -> ROOMS,
    ostrovokv3 -> ROOMS,
    lt -> TOURS,
    sunmar -> TOURS,
    oktogo -> ROOMS,
    sodis -> TOURS,
    hotels101 -> ROOMS,
    rozahutor -> ROOMS,
    travelline -> ROOMS,
    inna -> TOURS,
    vashotel -> ROOMS,
    kurortExpress -> ROOMS,
    hotelsCombined -> ROOMS
  )

  val ltDuplicatingPartners = Seq(Partners.inna)

  val channelManagers: Seq[Partner] = Seq(Partners.travelline)

  def getOpt(i: Int): Option[Partner] = Try(Partners(i)).toOption

  def isToursPartner(partner: Partner): Boolean = partner2searchType.contains(partner -> TOURS)
  def isRoomsPartner(partner: Partner): Boolean = partner2searchType.contains(partner -> ROOMS)
  def partnersByType(`type`: SearchType): Set[Partners.Value] =
    partner2searchType.filter(_._2 == `type`).map(_._1)
}