package ru.yandex.tours.model.hotels

/* @author berkut@yandex-team.ru */

object Star {
  val stars = Seq(Star(0, "unknown"), Star(1, "one"), Star(2, "two"),
    Star(3, "three"), Star(4, "four"), Star(5, "five"))

  val unifier = stars.map(t => t.name -> t).toMap
  val id2stars = stars.map(t => t.id -> t).toMap

  def getStar(x: String): Star = unifier.getOrElse(x.toLowerCase, stars(0))

  def getStar(star: Int): Star = if (star >= 0 || star < stars.length) {
    stars(star)
  } else {
    stars(0)
  }
}

case class Star private(id: Int, name: String)