package ru.yandex.tours.model

package object purchase {
  case class BillingObject(campaignId: String, uiInfo: Iterable[(String, String)], clickRevenue: Option[Long]) {
    def addUiInfo(newInfo: (String, String)*): BillingObject = this.copy(uiInfo = uiInfo ++ newInfo)
  }

  sealed trait PurchaseObject {
    def partnerName: String
    def billing: BillingObject
    def billingId: String
    def isTourOperator: Boolean
  }

  case class PurchaseWithGet(link: String,
                             partnerName: String,
                             billingId: String,
                             billing: BillingObject,
                             isTourOperator: Boolean) extends PurchaseObject

  case class PurchaseWithPost(link: String,
                              offer: String,
                              signature: String,
                              partnerName: String,
                              billingId: String,
                              billing: BillingObject) extends PurchaseObject {
    override def isTourOperator: Boolean = false
  }
}
