package ru.yandex.tours.model.search

import ru.yandex.tours.model.BaseModel.Currency
import ru.yandex.tours.model.Languages.Lang

/**
  * Created by Evgeny Zhoga on 20.01.16.
  */
trait ExtendedBaseRequest {
  def baseRequest: BaseRequest
  def hotelRequest: HotelSearchRequest = baseRequest.hotelRequest
}

case class ExtendedHotelSearchRequest(hotelSearchRequest: HotelSearchRequest,
                                      subRegionId: Option[Int] = None,
                                      hotelIds: Option[List[Int]] = None) extends ExtendedBaseRequest {
  val baseRequest = hotelSearchRequest

  val to = subRegionId.getOrElse(hotelSearchRequest.to)
  val from = hotelSearchRequest.from
  val nights = hotelSearchRequest.nights
  val when = hotelSearchRequest.when
  val ages = hotelSearchRequest.ages
  val flexWhen = hotelSearchRequest.flexWhen
  val flexNights = hotelSearchRequest.flexNights

  val currency: Currency = hotelSearchRequest.currency
  val lang: Lang = hotelSearchRequest.lang

  val guestsWithoutInfants = hotelSearchRequest.guestsWithoutInfants

  val filter: SearchFilter = hotelSearchRequest.filter
}

case class ExtendedOfferSearchRequest(offerSearchRequest: OfferSearchRequest) extends ExtendedBaseRequest {
  val baseRequest = offerSearchRequest

  val hotelId = offerSearchRequest.hotelId
}

case class ExtendedGetOfferRequest(getOfferRequest: GetOfferRequest) extends ExtendedBaseRequest {
  val baseRequest = getOfferRequest

  val toursInHotelRequest = getOfferRequest.toursInHotelRequest
  val tourId = getOfferRequest.tourId
}