package ru.yandex.tours.model.search

import org.apache.commons.codec.digest.DigestUtils

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.02.16
 */
case class FlightSearchRequest(hotelRequest: HotelSearchRequest, airportId: String) extends BaseRequest {
  require(airportId.nonEmpty, "airportId should be non empty")

  def asMap: Map[String, Any] = {
    hotelRequest.asMap + ("airport_id" -> airportId)
  }

  def encoded: String = {
    import hotelRequest._
    s"$from:$airportId:$nights:$when:${agesSerializable.mkString(",")}:$flexWhen:$flexNights"
  }

  def withFrom(from: Int): FlightSearchRequest = copy(hotelRequest = hotelRequest.copy(from = from))

  val sessionId = DigestUtils.md5Hex(encoded)
}
