package ru.yandex.tours.model.search

import ru.yandex.tours.model.search.SearchProducts.Offer

case class GetOfferRequest(toursInHotelRequest: OfferSearchRequest, tourId: String) extends BaseRequest {
  def asMap: Map[String, Any] = {
    toursInHotelRequest.asMap + ("tour_id" -> tourId)
  }

  def matches(offer: Offer): Boolean = {
    offer.getId == tourId || offer.getExternalId == tourId
  }

  override def hotelRequest: HotelSearchRequest = toursInHotelRequest.hotelRequest

  def extend(): ExtendedGetOfferRequest =
    ExtendedGetOfferRequest(getOfferRequest = this)
}