package ru.yandex.tours.model.search

import ru.yandex.tours.model.search.SearchRequests.ProtoOfferSearchRequest

/* @author berkut@yandex-team.ru */

object OfferSearchRequest {
  def apply(request: ProtoOfferSearchRequest): OfferSearchRequest = new OfferSearchRequest(
    HotelSearchRequest(request.getHotelRequest),
    request.getHotelId
  )
}

case class OfferSearchRequest(hotelRequest: HotelSearchRequest, hotelId: Int) extends BaseRequest {
  require(hotelId >= 0, "hotelId should be positive")

  def asMap: Map[String, Any] = {
    hotelRequest.asMap + ("hotel_id" -> hotelId)
  }

  val requestId: String = hotelRequest.sessionId + "-" + hotelId

  def toProto: ProtoOfferSearchRequest = {
    ProtoOfferSearchRequest.newBuilder()
      .setHotelId(hotelId)
      .setHotelRequest(hotelRequest.toProto)
      .build()
  }

  def extend(): ExtendedOfferSearchRequest =
    ExtendedOfferSearchRequest(offerSearchRequest = this)

}