package ru.yandex.tours.model.search

import org.joda.time.LocalDate
import ru.yandex.tours.model.util.{FlexNights, Nights, FlexDateInterval, DateInterval}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.08.15
 */
case class SearchDates(when: DateInterval,
                       nights: Nights,
                       whenBack: Option[DateInterval])

object SearchDates {
  def apply(when: LocalDate, nights: Int, flexWhen: Boolean, flexNights: Boolean): SearchDates = {
    SearchDates(
      FlexDateInterval(when, flexWhen),
      FlexNights(nights, flexNights),
      None
    )
  }

  def apply(request: BaseRequest): SearchDates = {
    apply(
      request.hotelRequest.when,
      request.hotelRequest.nights,
      request.hotelRequest.flexNights,
      request.hotelRequest.flexNights
    )
  }
}
