package ru.yandex.tours.model.search

import org.apache.commons.codec.digest.DigestUtils

/**
  * Created by asoboll on 25.04.16.
  */
case class TransferSearchRequest(offerRequest: OfferSearchRequest,
                                 airportId: String,
                                 userIp: Option[String]) extends BaseRequest {
  require(airportId.nonEmpty, "airportId should be non empty")

  override def hotelRequest: HotelSearchRequest = offerRequest.hotelRequest
  def hotelId: Int = offerRequest.hotelId

  def asMap: Map[String, Any] = {
    offerRequest.asMap + ("airport_id" -> airportId)
  }

  def encoded: String = {
    import offerRequest.hotelRequest._
    s"$airportId:$hotelId:$nights:$when:${ages.size}"
  }

  val sessionId = DigestUtils.md5Hex(encoded)
}

object TransferSearchRequest {
  def apply(hotelRequest: HotelSearchRequest,
            hotelId: Int,
            airportId: String,
            userIp: Option[String]): TransferSearchRequest =
    TransferSearchRequest(OfferSearchRequest(hotelRequest, hotelId), airportId, userIp)
}