package ru.yandex.tours.model.search.settings

import ru.yandex.tours.model.search.SearchOptions.SearchOption
import ru.yandex.tours.model.search.SearchType.SearchType
import ru.yandex.tours.model.search.{SearchOptions, SearchType}

/**
  * Created by Evgeny Zhoga on 04.02.16.
  */
case class SearchSettingsRecord(regionId: Int, parameters: Parameters) {
  def +(pair: (SearchType, SearchOption)): SearchSettingsRecord = {
    this.copy(parameters = parameters + pair)
  }

  def setLtActive(active: Boolean = true): SearchSettingsRecord = {
    this.copy(parameters = parameters.copy(ltActive = Some(active)))
  }
}

object SearchSettingsRecord {
  def empty(regionId: Int) = SearchSettingsRecord(regionId, Parameters(Map.empty, None))
}

case class Parameters(searchByType: Map[SearchType.SearchType, SearchOptions.SearchOption],
                      forcedSearchable: Option[Boolean], ltActive: Option[Boolean] = None) {

  def +(pair: (SearchType, SearchOption)): Parameters = {
    copy(searchByType = searchByType + pair)
  }
}
