package ru.yandex.tours.model.subscriptions

import org.joda.time.{DateTime, LocalDate}
import ru.yandex.tours.model.BaseModel.Pansion
import ru.yandex.tours.model.TourOperator
import ru.yandex.tours.model.hotels.Hotel

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.08.15
 */
case class Notification(created: DateTime,
                        subscription: Subscription,
                        payload: Notification.Payload)

object Notification {
  sealed trait Payload {
    def isEmpty: Boolean
    def nonEmpty: Boolean = !isEmpty
    def minPrice: Int
  }

  object Payload {
    def empty: Payload = Unknown
  }

  case object Unknown extends Payload {
    def isEmpty: Boolean = true
    def minPrice: Int = -1
  }

  case class DirectionOffers(offers: Seq[HotelOffers]) extends Payload {
    def isEmpty: Boolean = offers.isEmpty
    def minPrice: Int = offers.map(_.minPrice).min
  }

  case class HotelOffers(hotel: Hotel, offers: Seq[Offer]) extends Payload {
    def isEmpty: Boolean = offers.isEmpty
    def minPrice: Int = offers.map(_.price).min
  }

  case class Offer(when: LocalDate,
                   nights: Int,
                   pansion: Pansion,
                   operator: TourOperator,
                   price: Int,
                   created: DateTime)
}