package ru.yandex.tours.model.subscriptions

import ru.yandex.tours.model.filter.Filter
import ru.yandex.tours.model.search.SearchDates
import ru.yandex.tours.model.subscriptions.Subscriptions.State

import scala.concurrent.duration.FiniteDuration

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 03.08.15
 */
case class Subscription(user: UserIdentity,
                        id: String,
                        email: String,
                        interval: FiniteDuration,
                        state: State,
                        subject: Subscription.Subject) {
  def enabled: Boolean = state == State.ACTIVE
  def disabled: Boolean = !enabled
}


object Subscription {

  sealed trait Subject extends Serializable {
    def query: String
    def params: SubjectParams
    override def toString: String = query
  }

  case class Direction(query: String, geoId: Int, params: SubjectParams) extends Subject

  case class Hotel(query: String, hotelId: Int, params: SubjectParams) extends Subject


  case class SubjectParams(from: Int,
                           ages: Seq[Int],
                           dates: SearchDates,
                           filters: Seq[Filter])

}