package ru.yandex.tours.model.subscriptions

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.08.15
 */
sealed abstract class UserIdentity(val identityType: String, val identity: String) extends Serializable {
  override def toString = identityType + "/" + identity
}

case class Uid(uid: Long) extends UserIdentity("uid", uid.toString)

case class YandexUid(yuid: String) extends UserIdentity("yandexuid", yuid)

object UserIdentity {
  private object LongValue { def unapply(str: String) = Try(str.toLong).toOption }

  def apply(identityType: String, identity: String) = {
    (identityType, identity) match {
      case ("uid", LongValue(uid)) => Uid(uid)
      case ("yandexuid", yuid) => YandexUid(yuid)
      case _ => sys.error(s"Unknown user identity: $identityType/$identity")
    }
  }

  def fromString(string: String) = string.split("/") match {
    case Array("uid", LongValue(uid)) => Uid(uid)
    case Array("yandexuid", yuid) => YandexUid(yuid)
    case _ => sys.error("Unknown user identity: " + string)
  }
}