package ru.yandex.tours.model.util

import scala.util.Try

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 24.06.16
 */
case class Ages(ages: Seq[Int]) {

  require(ages.nonEmpty, "ages should not be empty")
  require(ages.forall(_ > 0), s"ages should be positive (${ages.mkString(",")})")

  val serializable: Vector[Int] = ages.toVector.sorted

  val kidsAges = ages.filter(Ages.isChild)
  val kidsAgesWithoutInfants = kidsAges.filterNot(Ages.isInfant)

  val adults = ages.size - kidsAges.size
  val kids = kidsAges.size
  val infants = ages.count(Ages.isInfant)

  val kidsWithoutInfants = kidsAgesWithoutInfants.size
  val guestsWithoutInfants = adults + kidsWithoutInfants

  override def toString: String = ages.mkString(",")
}

object Ages {

  def isChild(age: Int): Boolean = age < 18

  def isInfant(age: Int): Boolean = age < 2

  def parse(str: String): Ages = {
    new Ages(str.split(",").map(_.toInt))
  }

  def unapply(str: String): Option[Ages] = {
    Try(parse(str)).toOption
  }
}