package ru.yandex.tours.model.util

import ru.yandex.tours.model.search.HotelSearchRequest

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 07.09.15
 */
sealed trait Nights {
  def values: Seq[Int]
}

case class FlexNights(nights: Int, flexNights: Boolean) extends Nights {
  override def values: Seq[Int] = {
    val nightsShift = if (flexNights) HotelSearchRequest.NIGHTS_SHIFT else 0
    (nights - nightsShift) to (nights + nightsShift) filter (_ > 0)
  }
}

case class CustomNights(values: Seq[Int]) extends Nights