package ru.yandex.tours.model.util

import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.Prices.RecommendedDirection

/* @author berkut@yandex-team.ru */

object SortType extends Enumeration {
  type SortType = SortType.Value
  val RELEVANCE, PRICE_ASC, PRICE_DESC, RATING_ASC, RATING_DESC, VISITS = Value
  
  def sort(sortBy: SortType,
           directions: Seq[RecommendedDirection],
           relevanceSorter: Ordering[RecommendedDirection]): Seq[RecommendedDirection] = {
    sortBy match {
      case SortType.PRICE_ASC => directions.sortBy(d => (!d.hasPrice, d.getPrice))
      case SortType.PRICE_DESC => directions.sortBy(d => (!d.hasPrice, -d.getPrice))
      case _ => directions.sorted(relevanceSorter.reverse)
    }
  }
}
