package ru.yandex.tours.model.util

import org.joda.time.{DateTimeZone, LocalDate}
import ru.yandex.tours.model.BaseModel.LangToVal

package object proto {
  def fromLocalDate(date: LocalDate): Long = date.toDateTimeAtStartOfDay(DateTimeZone.UTC).getMillis

  def toLocalDate(millis: Long): LocalDate = new LocalDate(millis, DateTimeZone.UTC)

  def toLangVal(lang: String, name: String): LangToVal = LangToVal.newBuilder().setLang(lang).setValue(name).build()
}
