#!/bin/bash

DAEMON_BASE=tours
DAEMON=tours-notifier

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=/var/run/$DAEMON_BASE/$DAEMON.pid
LOG_DIR=/var/log/$DAEMON_BASE
HPROF_DIR=$LOG_DIR/hprof/$DAEMON
GC_LOG=$LOG_DIR/$DAEMON-gc.log
LIB_PATH=/usr/lib/yandex/$DAEMON/lib

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH
export PATH LANG JAVA_HOME CLASSPATH

LOG_FILE=$LOG_DIR/$DAEMON.log
STDOUT_LOG_FILE=$LOG_DIR/$DAEMON.log.shell

RESTART_MSG="Starting $DAEMON at `date '+%Y-%m-%d %H:%M:%S'`"
echo $RESTART_MSG >> $LOG_FILE
echo $RESTART_MSG > $STDOUT_LOG_FILE
echo "classpath: $CLASSPATH" >> $STDOUT_LOG_FILE

cd /etc/yandex/$DAEMON

exec -a "$DAEMON" \
java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Dtours.tmp.dir=${DAEMON} \
     -showversion -server -Xverify:none \
     -Xmx512m -Xms512m \
     -XX:+AlwaysPreTouch \
     -XX:+UseParNewGC \
     -XX:+UseConcMarkSweepGC \
     -XX:MaxTenuringThreshold=1 \
     -XX:SurvivorRatio=23 \
     -XX:+CMSScavengeBeforeRemark \
     -XX:CMSInitiatingOccupancyFraction=45 \
     -XX:+UseCMSInitiatingOccupancyOnly \
     -XX:+CMSParallelRemarkEnabled \
     -XX:+UseTLAB \
     -XX:+UseCondCardMark -XX:+UseNUMA \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -Dcom.sun.management.jmxremote \
     -Dcom.sun.management.jmxremote.port=36407 \
     -Dcom.sun.management.jmxremote.local.only=false \
     -Dcom.sun.management.jmxremote.authenticate=false \
     -Dcom.sun.management.jmxremote.ssl=false \
     -Djava.rmi.server.hostname=`/bin/hostname --fqdn` \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.NotifierMain >> $STDOUT_LOG_FILE 2>&1 &

echo $! > $PID_FILE
