package ru.yandex.tours.subscriptions

import ru.yandex.tours.model.subscriptions.{Notification, Subscription}
import ru.yandex.tours.util.Metrics
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 17.03.16
 */
class InstrumentedNotificationBuilder(client: NotificationBuilder) extends NotificationBuilder {
  private val metrics = Metrics("notification.builder")
  private val timer = metrics.getTimer("build")
  private val error = metrics.getMeter("error")

  override def build(subscription: Subscription): Future[Notification] = {
    val ctx = timer.time()
    client.build(subscription)
      .withTimerContext(ctx)
      .withErrorRateMeter(error)
  }
}
