package ru.yandex.tours.subscriptions

import ru.yandex.tours.model.subscriptions.{Notification, Subscription}
import ru.yandex.tours.util.Monitorings
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 16.03.16
 */
class MonitoredNotificationBuilder(builder: NotificationBuilder) extends NotificationBuilder {

  private val errorRate = Monitorings("notification.builder").errorRate(
    "errors", warningRate = 0.1, maxRate = 0.4
  )

  override def build(subscription: Subscription): Future[Notification] = {
    builder.build(subscription)
      .withErrorReservoir(errorRate)
  }
}
