package ru.yandex.tours.subscriptions.sender

import ru.yandex.tours.model.subscriptions.Letter
import ru.yandex.tours.util.Metrics

import scala.util.control.NonFatal

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 16.03.16
 */
class InstrumentedMailSender(sender: MailSender) extends MailSender {

  private val metrics = Metrics(s"mail.sender")
  private val sendTimer = metrics.getTimer("send")
  private val errorMeter = metrics.getMeter("errors")

  override def send(letter: Letter): Unit = {
    val ctx = sendTimer.time()
    try {
      sender.send(letter)
    } catch {
      case NonFatal(t) =>
        errorMeter.mark()
        throw t
    } finally {
      ctx.stop()
    }
  }
}
