package ru.yandex.tours.subscriptions.sender

import ru.yandex.tours.model.subscriptions.Letter
import ru.yandex.tours.util.Monitorings

import scala.util.control.NonFatal

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 16.03.16
 */
class MonitoredMailSender(sender: MailSender) extends MailSender {
  private val errorRate = Monitorings("mail.sender").errorRate(
    "errors", warningRate = 0.1, maxRate = 0.4
  )

  override def send(letter: Letter): Unit = {
    try {
      sender.send(letter)
      errorRate.ok()
    } catch {
      case NonFatal(t) =>
        errorRate.error(t)
        throw t
    }
  }
}
