package ru.yandex.tours.subscriptions.storage

import java.io._

import org.apache.commons.lang.SerializationUtils
import ru.yandex.tours.model.subscriptions.{UserIdentity, Notification}
import ru.yandex.tours.storage.subscriptions.{SubscriptionStorage, NotificationStorage}
import ru.yandex.tours.util.Logging
import ru.yandex.tours.util.file.RichFile

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Failure

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.08.15
 */
class MockNotificationStorage(subscriptionStorage: SubscriptionStorage)
                             (implicit ec: ExecutionContext) extends NotificationStorage with Logging {

  private val dir = new File("notifications")
  require(dir.exists() || dir.mkdirs())

  private def loadNotification(id: String): Option[Notification] = {
    val file = dir / id
    if (!file.exists()) return None

    val obj = SerializationUtils.deserialize(new FileInputStream(file)).asInstanceOf[Notification]
    Some(obj)
  }

  override def getLastNotification(user: UserIdentity, id: String): Future[Option[Notification]] = {
    Future(loadNotification(id)).andThen {
      case Failure(t) => log.error("Failed to load last notification", t)
    }
  }

  override def saveNotification(notification: Notification): Future[Unit] = Future {
    SerializationUtils.serialize(notification, new FileOutputStream(dir / notification.subscription.id))
  }
}
