#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java7
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=../$DAEMON.pid

CLASSPATH=`find lib -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

exec java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -showversion -server -Xverify:none \
     -Xmx1024m -Xms1024m \
     -XX:+UseG1GC \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dlogging.path=. \
     -Dcom.sun.management.jmxremote \
     -Dcom.sun.management.jmxremote.port=36406 \
     -Dcom.sun.management.jmxremote.local.only=false \
     -Dcom.sun.management.jmxremote.authenticate=false \
     -Dcom.sun.management.jmxremote.ssl=false \
     -Djava.rmi.server.hostname=`/bin/hostname --fqdn` \
     ru.yandex.tours.PartnerMockMain >> $DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE