#!/bin/sh

. ./component.sh

JAVA_HOME=/usr/local/java8
PATH="$JAVA_HOME/bin:$PATH"
LANG=ru_RU.UTF8
PID_FILE=$DAEMON.pid
LOG_DIR=./logs
HPROF_DIR=hprof/$DAEMON
GC_LOG=$DAEMON-gc.log
LIB_PATH=lib
mkdir -p logs

CLASSPATH=`find $LIB_PATH -name '*.jar' -printf '%p:'`$CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH
#-agentpath:./libyjpagent.so \

exec -a "$DAEMON" \
java -classpath $CLASSPATH  \
     -Dfile.encoding=UTF8 \
     -Doracle.net.tns_admin=/etc/oracle \
     -showversion -server -Xverify:none \
     -Xmx1536m -Xms1536m \
     -XX:+UseG1GC \
     -XX:+HeapDumpOnOutOfMemoryError \
     -XX:HeapDumpPath=$HPROF_DIR \
     -XX:OnOutOfMemoryError="echo on oom killing process %p; kill -9 %p" \
     -Xloggc:$LOG_DIR/$GC_LOG \
     -XX:+PrintCommandLineFlags \
     -XX:+PrintGCApplicationStoppedTime \
     -XX:+PrintGCDetails \
     -XX:+PrintGCDateStamps \
     -Dcom.sun.management.jmxremote \
     -Dcom.sun.management.jmxremote.port=36423 \
     -Dcom.sun.management.jmxremote.local.only=false \
     -Dcom.sun.management.jmxremote.authenticate=false \
     -Dcom.sun.management.jmxremote.ssl=false \
     -Djava.rmi.server.hostname=`/bin/hostname --fqdn` \
     -Dhost.name=`/bin/hostname --fqdn` \
     -Djava.net.preferIPv6Addresses=true \
     -Dsun.net.client.defaultConnectTimeout=10000 \
     -Dsun.net.client.defaultReadTimeout=10000 \
     -Dsun.net.inetaddr.ttl=86400 -Dhttp.keepAlive=false \
     -Dlogging.path=$LOG_DIR \
     ru.yandex.tours.SearcherMain >> $LOG_DIR/$DAEMON.log.shell 2>&1 &

echo $! > $PID_FILE