package ru.yandex.tours

import akka.actor.Props
import ru.yandex.tours.app.{AkkaSupport, Application, AviaClientSupport, CommonDataHolders}
import ru.yandex.tours.backend.flight.{AviaSearcher, LocalFlightSearchService, RootAviaSearcherActor, SimpleAviaSearcher}
import ru.yandex.tours.storage.StorageComponents

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.02.16
 */
trait AviaSearcherSupport { this: Application
  with AkkaSupport
  with StorageComponents
  with CommonDataHolders
  with AviaClientSupport =>

  lazy val aviaSearcherActor = akkaSystem.actorOf(
    Props(new RootAviaSearcherActor(aviaClient, airports)),
    "avia-searcher"
  )
  private lazy val simpleAviaSearcher = if (useSimpleAvia) {
    Option(new SimpleAviaSearcher(aviaClient, airports) (akkaSystem.dispatcher))
  } else Option.empty

  lazy val flightsSearchService = new LocalFlightSearchService(flightsStorage,
                                                               searchSettings,
                                                               aviaSearcherActor,
                                                               simpleAviaSearcher) (akkaSystem.dispatcher, akkaSystem)

}
