package ru.yandex.tours.backend.events

import akka.actor.Actor
import ru.yandex.tours.events.SearchEvent
import ru.yandex.tours.events.SearchEvent._
import ru.yandex.tours.prices.PriceHistoryStorage
import ru.yandex.tours.util.collections.SimpleBitSet

import scala.collection.JavaConverters._

/**
 * Author: Krasheninnikov Alexander (alexcrush@yandex-team.ru)
 * Created: 2018.03.07
 */
class PriceHistoryTransfer(priceHistoryStorage: PriceHistoryStorage) extends Actor {

  context.system.eventStream.subscribe(self, classOf[SearchEvent])

  override def receive: Receive = {
    case e @ FoundSnippets(ts, req, res) =>
      val snippets = res.getHotelSnippetList.asScala
      val failed = SimpleBitSet.from(res.getProgress.getOperatorFailedSet).toSet
      priceHistoryStorage += (ts, req, snippets, failed.nonEmpty)
      priceHistoryStorage.flush()
    case e @ FoundOffers(ts, req, res) =>
      val offers = res.getOfferList.asScala
      val failed = SimpleBitSet.from(res.getProgress.getOperatorFailedSet).toSet
      priceHistoryStorage += (ts, req, offers, failed.nonEmpty)
      priceHistoryStorage.flush()
    case e @ FoundFlights(_, req, res) =>
    case e @ FoundTransfers(_, req, res) =>
    case e @ Actualized(_, req, offer) =>
  }
}
