package ru.yandex.tours.backend.flight

import akka.actor.{Actor, OneForOneStrategy, SupervisorStrategy}
import ru.yandex.tours.avia.{Airports, AviaClient}
import ru.yandex.tours.backend.flight.RootAviaSearcherActor.SpawnSearcher
import ru.yandex.tours.model.search.FlightSearchRequest
import ru.yandex.tours.model.search.SearchProducts.FlightTrip
import ru.yandex.tours.util.Metrics

import scala.concurrent.Promise
import scala.util.control.NonFatal

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 10.02.16
 */
class RootAviaSearcherActor(aviaClient: AviaClient, airports: Airports) extends Actor {

  Metrics("actors." + self.path.name).newGauge("children") { context.children.size }

  override def receive: Receive = {
    case SpawnSearcher(request, promise) =>
      val childName = request.sessionId
      context.child(childName).getOrElse {
        context.actorOf(AviaSearcher.props(aviaClient, airports, request, promise), childName)
      }
  }

  override def supervisorStrategy: SupervisorStrategy = OneForOneStrategy() {
    case NonFatal(_) ⇒ SupervisorStrategy.Stop
  }
}

object RootAviaSearcherActor {
  case class SpawnSearcher(request: FlightSearchRequest, promise: Promise[Seq[FlightTrip]])
}
