package ru.yandex.tours.backend.search

import akka.actor.{Actor, ActorRef}
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.BaseRequest
import ru.yandex.tours.model.search.SearchResults.Context
import ru.yandex.tours.storage.ToursDao
import ru.yandex.tours.util.Logging

import scala.util.{Failure, Success}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 07.03.15
 */
abstract class AbstractRequestHolder[T <: BaseRequest, R <: AnyRef](storage: ToursDao,
                                                                    request: T,
                                                                    partners: Map[Partner, ActorRef])
  extends Actor with Logging {

  import context.dispatcher

  protected val selfName = getClass.getSimpleName + " (" + request.hotelRequest.sessionId + ")"

  protected def getRequestToPartner(partner: Partner, ctx: Context): Option[AnyRef]

  protected def onStop(): Unit = ()

  override def preStart(): Unit = {
    log.info(s"Starting $selfName for request $request")
    storage.getContext(request.hotelRequest).onComplete {
      case Success(ctx) ⇒
        for {
          (partner, ref) ← partners
          request ← getRequestToPartner(partner, ctx)
        } ref ! request
      case Failure(e) ⇒
        log.error(s"Can not get context for request $request", e)
        context.stop(self)
    }
  }

  override def postStop(): Unit = {
    log.info(s"$selfName finished for request $request")
    onStop()
  }
}
