package ru.yandex.tours.backend.search

import ru.yandex.tours.model.Source
import ru.yandex.tours.util.Metrics

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.03.15
 */
class RequestMetrics(name: String, operators: Iterable[Source]) {
  private val metrics = Metrics("request." + name)
  private val timerCtx = metrics.getTimer("time").time()
  private val emptyResults = metrics.getMeter("empty")

  private val operatorMetrics = operators.map(o => o -> metrics("operator")(o.code)).toMap
  private val operatorTimers = operatorMetrics.map{ case (k, v) => k -> v.getTimer("time").time() }

  def successOperator(operator: Source): Unit = {
    operatorTimers.get(operator).foreach(_.stop)
    operatorMetrics.get(operator).foreach(_.getMeter("success").mark())
  }

  def skippedOperator(operator: Source): Unit = {
    operatorTimers.get(operator).foreach(_.stop)
    operatorMetrics.get(operator).foreach(_.getMeter("skipped").mark())
  }

  def failedOperator(operator: Source): Unit = {
    operatorTimers.get(operator).foreach(_.stop)
    operatorMetrics.get(operator).foreach(_.getMeter("failure").mark())
  }

  def finishedRequest(nonEmptyResult: Boolean): Unit = {
    if (!nonEmptyResult) emptyResults.mark()
    timerCtx.stop()
  }

}
