package ru.yandex.tours.backend.transfer

import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.util.Metrics
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
  * Created by asoboll on 27.04.16.
  */
class InstrumentedTransferClient(client: TransferClient) extends TransferClient {
  def clientName = client.clientName

  private val metrics = Metrics("transfer." + clientName)
  private val getTimer = metrics.getTimer("get")
  private val getErrors = metrics.getMeter("errors.get")

  override def searchTransfers(transferSearchRequest: TransferSearchRequest): Future[TransferClient.Response] = {
    val ctx = getTimer.time()
    client.searchTransfers(transferSearchRequest)
      .withTimerContext(ctx)
      .withErrorRateMeter(getErrors)
  }
}
