package ru.yandex.tours.backend.transfer

import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.util.Monitorings
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
  * Created by asoboll on 27.04.16.
  */
class MonitoredTransferClient(client: TransferClient) extends TransferClient {
  def clientName = client.clientName

  private val errorRate = Monitorings("transfer.client", devOnly = true).errorRate(
    "errors", warningRate = 0.1, maxRate = 0.4
  )

  override def searchTransfers(transferSearchRequest: TransferSearchRequest): Future[TransferClient.Response] = {
    client.searchTransfers(transferSearchRequest)
      .withErrorReservoir(errorRate)
  }
}
