package ru.yandex.tours.backend.transfer

import akka.actor.{Actor, OneForOneStrategy, SupervisorStrategy}
import ru.yandex.tours.backend.transfer.RootTransferSearcherActor.SpawnSearcher
import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.util.Metrics

import scala.concurrent.Promise
import scala.util.control.NonFatal

/**
  * Created by asoboll on 25.04.16.
  */
class RootTransferSearcherActor(transferClient: TransferClient) extends Actor {

  Metrics("actors." + self.path.name).newGauge("children") { context.children.size }

  override def receive: Receive = {
    case SpawnSearcher(request, promise) =>
      val childName = request.sessionId
      context.child(childName).getOrElse {
        context.actorOf(TransferSearcher.props(transferClient, request, promise), childName)
      }
  }

  override def supervisorStrategy: SupervisorStrategy = OneForOneStrategy() {
    case NonFatal(_) ⇒ SupervisorStrategy.Stop
  }
}

object RootTransferSearcherActor {
  case class SpawnSearcher(request: TransferSearchRequest, promise: Promise[TransferClient.Response])
}