package ru.yandex.tours.backend.transfer

import ru.yandex.tours.model.search.TransferSearchRequest
import ru.yandex.tours.util.Throttler

import scala.concurrent.Future

/**
  * Created by asoboll on 29.06.16.
  */
class ThrottledTransferClient(client: TransferClient, throttler: Throttler) extends TransferClient {
  def clientName = client.clientName

  override def searchTransfers(transferSearchRequest: TransferSearchRequest): Future[TransferClient.Response] = {
      throttler.throttle("enqueue", clientName) {
        client.searchTransfers(transferSearchRequest)
      }
    }

}
