package ru.yandex.tours.backend.transfer

import ru.yandex.tours.model.search.SearchProducts.TransferOption
import ru.yandex.tours.model.search.TransferSearchRequest

import scala.concurrent.Future

/**
  * Created by asoboll on 25.04.16.
  */
trait TransferClient {
  def clientName: String

  def searchTransfers(transferSearchRequest: TransferSearchRequest): Future[TransferClient.Response]
}

object TransferClient {
  case class TransferParsingException(e: Exception)

  case class Response(transfers: Seq[TransferOption],
                      errors: Seq[TransferParsingException],
                      requestUrl: Option[String] = None)
}