package ru.yandex.tours.backend.transfer

import akka.actor.Props
import ru.yandex.tours.app.{AkkaSupport, Application, CommonDataHolders, HttpSupport}
import ru.yandex.tours.storage.StorageComponents
import ru.yandex.tours.util.Throttler

/**
  * Created by asoboll on 25.04.16.
  */
trait TransferSearchSupport { this: Application
  with HttpSupport
  with AkkaSupport
  with StorageComponents
  with CommonDataHolders =>

  def throttler: Throttler

  lazy val carTrawlerClient: TransferClient = {
    val conf = config.getConfig("car_trawler")
    val client = new CarTrawlerClient(
      hotelsIndex,
      airports,
      externalHttpClient,
      conf
    )(akkaSystem.dispatcher)

    val intrumentedClient = new InstrumentedTransferClient(client)
    val monitoredClient = new MonitoredTransferClient(intrumentedClient)
    val throttledClient = new ThrottledTransferClient(monitoredClient, throttler)
    throttledClient
  }

  lazy val transferSearcherActor = akkaSystem.actorOf(
    Props(new RootTransferSearcherActor(carTrawlerClient)),
    "transfer-searcher"
  )

  lazy val transferSearchService =
    new LocalTransferSearchService(transferStorage, transferSearcherActor)(akkaSystem.dispatcher, akkaSystem)
}
