package ru.yandex.tours.partners

import javax.xml.ws.{Response, AsyncHandler}

import scala.concurrent.{Promise, Future}
import scala.util.Try

object AsyncWsdlUtil {
  def wrap[T](f: AsyncHandler[T] => Any): Future[T] = {
    val promise = Promise.apply[T]()
    val handler = new AsyncHandler[T] {
      override def handleResponse(res: Response[T]): Unit = {
        promise.tryComplete(Try(res.get()))
      }
    }
    f(handler)
    promise.future
  }
}
