package ru.yandex.tours.partners

import ru.yandex.tours.model.Source
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.util.Logging

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Failure

class FailLogSourceClient[S <: Source](client: SourceClient[S])
                                      (implicit ec: ExecutionContext) extends SourceClient[S] with Logging {
  override def searchHotels(request: ExtendedHotelSearchRequest, source: S): Future[Iterable[HotelSnippet]] = {
    wrap(s"Search hotels $request", source, client.searchHotels(request, source))
  }

  override def searchOffers(request: ExtendedOfferSearchRequest, source: S): Future[Iterable[Offer]] = {
    wrap(s"Search offers $request", source, client.searchOffers(request, source))
  }

  override def actualizeOffer(offer: ActualizedOffer, source: S): Future[ActualizedOffer] = {
    wrap("Actualize offer", source, client.actualizeOffer(offer, source))
  }

  private def wrap[T](name: String, source: S, future: Future[T]) = {
    future.andThen {
      case Failure(e) => log.warn(s"$name ${source.name} failed!", e)
    }
  }
}
