package ru.yandex.tours.partners

import ru.yandex.tours.model.HotelProvider
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.util.hotels.HotelSnippetUtil

import scala.concurrent.Future

trait HotelProviderClient extends SourceClient[HotelProvider] {
  def partner: Partner

  def offersToSnippets(offers: Iterable[Offer]): Iterable[HotelSnippet] = HotelSnippetUtil.aggregate(offers)

  override def actualizeOffer(offer: ActualizedOffer, source: HotelProvider): Future[ActualizedOffer] = {
    Future.failed(new Exception(s"$partner searcher cannot actualize offers"))
  }
}
