package ru.yandex.tours.partners

import ru.yandex.tours.model.Source
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.model.search.{ExtendedOfferSearchRequest, ExtendedHotelSearchRequest, HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.{ExecutionContext, Future}

class InstrumentedSourceClient[S <: Source](partner: Partner, client: SourceClient[S])
                                           (implicit val ec: ExecutionContext)
  extends SourceClient[S] with InstrumentedPartnerClient {

  override def searchHotels(request: ExtendedHotelSearchRequest, source: S): Future[Iterable[HotelSnippet]] =
    wrap(partner, "hotels", client.searchHotels(request, source))

  override def searchOffers(request: ExtendedOfferSearchRequest, source: S): Future[Iterable[Offer]] =
    wrap(partner, "offers", client.searchOffers(request, source))

  override def actualizeOffer(offer: ActualizedOffer, source: S): Future[ActualizedOffer] =
    wrap(partner, "actualize", client.actualizeOffer(offer, source))
}
