package ru.yandex.tours.partners

import ru.yandex.tours.model.Source
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.model.search.{ExtendedOfferSearchRequest, ExtendedHotelSearchRequest, HotelSearchRequest, OfferSearchRequest}

import scala.concurrent.Future

trait SourceClient[S <: Source] {
  def searchHotels(request: ExtendedHotelSearchRequest, source: S): Future[Iterable[HotelSnippet]]

  def searchOffers(request: ExtendedOfferSearchRequest, source: S): Future[Iterable[Offer]]

  def actualizeOffer(offer: ActualizedOffer, source: S): Future[ActualizedOffer]
}
