package ru.yandex.tours.partners

import ru.yandex.tours.model.Source
import ru.yandex.tours.model.hotels.Partners._
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.search.SearchResults.ActualizedOffer
import ru.yandex.tours.model.search.{ExtendedOfferSearchRequest, ExtendedHotelSearchRequest, HotelSearchRequest, OfferSearchRequest}
import ru.yandex.tours.util.Throttler

import scala.concurrent.{ExecutionContext, Future}

class ThrottledSourceClient[S <: Source](partner: Partner, client: SourceClient[S], throttler: Throttler)
                                        (implicit val ec: ExecutionContext) extends SourceClient[S] {
  override def searchHotels(request: ExtendedHotelSearchRequest, source: S): Future[Iterable[HotelSnippet]] = {
    throttler.throttle("enqueue", partner.toString) {
      client.searchHotels(request, source)
    }
  }

  override def searchOffers(request: ExtendedOfferSearchRequest, source: S): Future[Iterable[Offer]] = {
    throttler.throttle("results", partner.toString) {
      client.searchOffers(request, source)
    }
  }

  override def actualizeOffer(offer: ActualizedOffer, source: S): Future[ActualizedOffer] = {
    throttler.throttle("results", partner.toString) {
      client.actualizeOffer(offer, source)
    }
  }
}