package ru.yandex.tours.partners.hotelscombined

import ru.yandex.tours.model.HotelProvider
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}

/**
  * Created by asoboll on 02.12.16.
  */
object HotelsCombinedResponse {
  sealed trait Response[T] {
    def provider2rates: Map[HotelProvider, Iterable[T]]

    def isComplete: Boolean
  }

  case class Offers(provider2rates: Map[HotelProvider, Iterable[Offer]],
                    isComplete: Boolean) extends Response[Offer]

  case class Hotels(provider2rates: Map[HotelProvider, Iterable[HotelSnippet]],
                    isComplete: Boolean,
                    numberRates: Int) extends Response[HotelSnippet]

}
