package ru.yandex.tours.partners.hotelscombined.client

import akka.util.Timeout
import ru.yandex.tours.hotels.HotelsIndex
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.operators.HotelProviders
import ru.yandex.tours.partners.HotelsCombinedHttp.authHeaders
import ru.yandex.tours.partners.PartnerRequestProcessing
import ru.yandex.tours.partners.hotelscombined.{HotelsCombinedParser, HotelsCombinedResponse}
import ru.yandex.tours.util.http.AsyncHttpClient
import spray.http.Uri

import scala.concurrent.duration._
import scala.concurrent.{ExecutionContext, Future}
import scala.util.Try

/**
  * Created by asoboll on 01.12.16.
  */
class DefaultHotelsCombinedClient(val partner: Partner,
                                  hotelsIndex: HotelsIndex,
                                  protected val httpClient: AsyncHttpClient,
                                  hotelProviders: HotelProviders,
                                  timeout: Timeout = Timeout(60.seconds))
                                 (implicit val ec: ExecutionContext)
  extends HotelsCombinedClient with PartnerRequestProcessing {

  implicit protected val implicitTimeout = timeout

  private val parser = new HotelsCombinedParser(partner, hotelsIndex, hotelProviders)

  def searchHotels(request: ExtendedHotelSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Hotels] = {
    handleBytes(
      uri,
      parser.parseHotels(request, _),
      authHeaders
    )
  }

  def searchOffers(request: ExtendedOfferSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Offers] = {
    handleBytes(
      uri,
      parser.parseOffers(request, _),
      authHeaders
    )
  }

}
