package ru.yandex.tours.partners.hotelscombined.client

import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.partners.hotelscombined.HotelsCombinedResponse
import spray.http.Uri

import scala.concurrent.Future
import scala.util.Try

trait HotelsCombinedClient {
  def partner: Partner

  def searchHotels(request: ExtendedHotelSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Hotels]

  def searchOffers(request: ExtendedOfferSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Offers]
}
