package ru.yandex.tours.partners.hotelscombined.client

import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.partners.InstrumentedPartnerClient
import ru.yandex.tours.partners.hotelscombined.HotelsCombinedResponse
import spray.http.Uri

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Try

/**
  * Created by asoboll on 14.12.16.
  */
trait InstrumentedHotelsCombinedClient extends HotelsCombinedClient with InstrumentedPartnerClient {

  implicit val ec: ExecutionContext

  abstract override def searchHotels(request: ExtendedHotelSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Hotels] =
    wrap(partner, "hotels", super.searchHotels(request, uri))

  abstract override def searchOffers(request: ExtendedOfferSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Offers] =
    wrap(partner, "offers", super.searchOffers(request, uri))

}
