package ru.yandex.tours.partners.hotelscombined.client

import ru.yandex.tours.model.search.{ExtendedHotelSearchRequest, ExtendedOfferSearchRequest}
import ru.yandex.tours.partners.hotelscombined.HotelsCombinedResponse
import ru.yandex.tours.util.Throttler
import spray.http.Uri

import scala.concurrent.{ExecutionContext, Future}
import scala.util.Try

/**
  * Created by asoboll on 14.12.16.
  */
class ThrottledHotelsCombinedClient(client: HotelsCombinedClient, throttler: Throttler)
                                   (implicit val ec: ExecutionContext) extends HotelsCombinedClient {

  def partner = client.partner

  def searchHotels(request: ExtendedHotelSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Hotels] =
    throttler.throttle("enqueue", partner.toString) {
      client.searchHotels(request, uri)
    }

  def searchOffers(request: ExtendedOfferSearchRequest, uri: Try[Uri]): Future[HotelsCombinedResponse.Offers] =
    throttler.throttle("results", partner.toString) {
      client.searchOffers(request, uri)
    }

}
