package ru.yandex.tours.partners.hotelscombined.downloader

import ru.yandex.tours.model.search.ExtendedHotelSearchRequest
import ru.yandex.tours.model.search.SearchProducts.HotelSnippet
import ru.yandex.tours.partners.HotelsCombinedHttp.RichHCUri
import ru.yandex.tours.partners.IllegalStatusCodeException
import ru.yandex.tours.partners.PartnerProtocol.{Partial, SnippetsResult, Successful}
import ru.yandex.tours.partners.hotelscombined.HotelsCombinedResponse.Hotels
import ru.yandex.tours.partners.hotelscombined.client.HotelsCombinedClient
import ru.yandex.tours.partners.hotelscombined.downloader.AbstractHCDownloader.{DownloadRequest, DownloadResult}
import spray.http.StatusCodes

import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

/**
  * Created by asoboll on 27.01.17.
  */
class HotelsHCDownloader(client: HotelsCombinedClient, pollInterval : FiniteDuration)
                        (implicit ec: ExecutionContext, requestTimeout: FiniteDuration)
  extends AbstractHCDownloader[HotelSnippet, Hotels, ExtendedHotelSearchRequest](client, pollInterval) {

  protected val metrics: HCMetrics = HCMetrics(client.partner.toString, "hotels")

  protected val formResult = SnippetsResult.apply _

  protected def doSearch(request: DownloadRequest[ExtendedHotelSearchRequest]): Future[Hotels] =
    client.searchHotels(request.request, request.uri)

  protected def manageResponse(dlRequest: DownloadRequest[ExtendedHotelSearchRequest])
                              (response: Hotels): (DownloadResult, DownloadRequest[ExtendedHotelSearchRequest]) = {
    val allRates = response.numberRates <= dlRequest.uri.get.lastRateIndex
    dlRequest.providers.foreach { provider =>
      val rates = response.provider2rates.getOrElse(provider, Iterable.empty)
      if (response.isComplete || rates.nonEmpty) {
        val results = if (response.isComplete && allRates) Successful(rates) else Partial(rates)
        dlRequest.requestHolder ! formResult(provider, results, 0)
      }
    }
    val requestUpdated = if (response.isComplete && !allRates) {
      dlRequest.copy(uri = dlRequest.uri.map(_.nextPage))
    } else dlRequest
    (DownloadResult(
      response.isComplete && allRates,
      response.provider2rates.isEmpty,
      response.isComplete),
      requestUpdated)
  }

  protected def fallbacks(request: DownloadRequest[ExtendedHotelSearchRequest]) = {
    case e@IllegalStatusCodeException(StatusCodes.NotFound, msg)
      if msg.contains("Destination not searchable") =>
      (skipSearch(e, request), request)
  }
}
