package ru.yandex.tours.partners.hotelscombined.downloader

import ru.yandex.tours.model.HotelProvider
import ru.yandex.tours.model.search.ExtendedOfferSearchRequest
import ru.yandex.tours.model.search.SearchProducts.Offer
import ru.yandex.tours.partners.HotelsCombinedHttp.RichHCUri
import ru.yandex.tours.partners.IllegalStatusCodeException
import ru.yandex.tours.partners.PartnerProtocol.{OffersResult, Successful}
import ru.yandex.tours.partners.hotelscombined.HotelsCombinedResponse.Offers
import ru.yandex.tours.partners.hotelscombined.client.HotelsCombinedClient
import ru.yandex.tours.partners.hotelscombined.downloader.AbstractHCDownloader.{DownloadRequest, DownloadResult}
import spray.http.StatusCodes

import scala.collection.mutable
import scala.concurrent.duration.FiniteDuration
import scala.concurrent.{ExecutionContext, Future}

/**
  * Created by asoboll on 27.01.17.
  */
class OffersHCDownloader(client: HotelsCombinedClient, pollInterval : FiniteDuration)
                        (implicit ec: ExecutionContext, requestTimeout: FiniteDuration)
  extends AbstractHCDownloader[Offer, Offers, ExtendedOfferSearchRequest](client, pollInterval) {

  protected val metrics: HCMetrics = HCMetrics(client.partner.toString, "offers")

  protected val formResult = OffersResult.apply _

  protected def doSearch(request: DownloadRequest[ExtendedOfferSearchRequest]): Future[Offers] =
    client.searchOffers(request.request, request.uri)

  protected def manageResponse(dlRequest: DownloadRequest[ExtendedOfferSearchRequest])
                              (response: Offers): (DownloadResult, DownloadRequest[ExtendedOfferSearchRequest]) = {
    val providersDone = mutable.Set.empty[HotelProvider]
    dlRequest.providers.foreach { provider =>
      val rates = response.provider2rates.getOrElse(provider, Iterable.empty)
      if (response.isComplete || rates.nonEmpty) {
        dlRequest.requestHolder ! formResult(provider, Successful(rates), 0)
        providersDone += provider
      }
    }
    val requestUpdated = if (providersDone.isEmpty) dlRequest
    else dlRequest.copy(providers = dlRequest.providers diff providersDone)
    (DownloadResult(response.isComplete, response.provider2rates.isEmpty), requestUpdated)
  }

  protected def fallbacks(request: DownloadRequest[ExtendedOfferSearchRequest]) = {
    case e@IllegalStatusCodeException(StatusCodes.NotFound, msg) if msg.contains("Destination not searchable") =>
      (DownloadResult(isComplete = false, isEmpty = true, retryNow = true),
        request.copy(request.uri.map(_.withNoDestination)))
  }
}
